# Changelog

## 1.2.7 (April 28, 2021)

 - Fix PHP warning related to automatic updates (WordPress).

### Sources

  - Fix Google Sheet warning when loading an empty spreadsheet.
  - Fix Google Sheet content caching.
  - Fix Instagram refresh token issue.

### Icons

  - Fix icons collections build.
  - Fix invalid cache key warning.

## 1.2.6 (April 13, 2021)

### Forms

  - Add Horizontal layout for Checkbox & Radio fields.
  - Add Grid Columns setting for the form input field.
  - Fix Builder form fields listing.
  - Fix SaveToCSV multi options fields parsing.
  - Fix form rendering after cache clearance.

## 1.2.5 (April 7, 2021)

  - Fix conflicts with 3rd-parties dependencies.

### Sources

  - Add configuration pre saving tests.
  - Fix broken mapping after some configuration changes.

### Forms

  - Change actions JavaScript hooks workflow.
  - Fix Checkbox Field validation.
  - Fix email action attachments support.
  - Fix quick access to Form Area Builder settings.

## 1.2.4 (March 27, 2021)

  - Fix Forms settings being deleted when Form Area is disabled.

## 1.2.3 (March 25, 2021)

  - Fix UI regression.
  - Fix Form Date field min/max attributes support.
  - Change YOOtheme Pro min version to 2.3.32.

## 1.2.2 (March 21, 2021)

 - Fix general UI issues.

### Forms

 - Add support for fields Tag Replacement in Upload field upload path.
 - Fix Email Action sending test & attachments related issues.

## 1.2.1 (March 13, 2021)

  - Change YOOtheme Pro min version to 2.3.18.

### Forms

  - Fix Checkbox Field values submission.

### Icons

  - Fix Icons picker loader regression.

## 1.2.0 (March 10, 2021)

  - Add Sources Addon 🥳

### Forms

  - Add support for spaces in field names.
  - Add support for custom action url and method.
  - Add a simple send email test for Email action.
  - Add Columns configuration for SaveToCSV action.
  - Add optional name field to actions for easier identification.
  - Add configuration quick access through the Status Icon (requires YTP 2.3.26 or above).
  - Add support for empty value and disabled attribute in Option fields (Select, Radio, Checkbox).
  - Add support for Submission Tag Replacement on missing Email Action fields (ccs, bccs, reply_tos, from).
  - Change Message action to use UIkit Modal dialog instead of alert.

### Access

  - Add Datetime access rule.
  - Add configuration quick access through the Status Icon (requires YTP 2.3.26 or above).
  - Change User Access rule to display Guest setting as a role (WordPress).

### Elements

  - Add Pinterest Social Sharing network.
  - Add Social Sharing popup window option.

## 1.1.8 (March 9, 2021)

  - Fix session handler (WordPress).

### Forms

  - Fix upload validation and edge configuration issues.
  - Fix Send Email as HTML default fallback in Email action.
  - Fix Save to CSV action headers format when using custom delimiter.

## 1.1.7 (February 22, 2021)

### Forms

  - Fix form related PHP warnings.
  - Fix Upload element mimetype validation.
  - Fix support for multiple forms rendering on the same page.

### Icons

  - Fix icon related PHP warnings.
  - Fix support for multiple icons declared as HTML in the same field.

## 1.1.6 (February 10, 2021)

  - Fix plugin execution time (WordPress).
  - Fix support for icons set as HTML.

### Forms

  - Fix Fieldset Horizontal Layout display.
  - Fix multiple email parsing for Email action.
  - Fix Input element attributes rendering.

## 1.1.5 (January 9, 2021)

  - Fix MyIcons tab display (WordPress).

## 1.1.4 (December 23, 2020)

  - Fix icons Builder integration for pre YOOtheme Pro 2.3.
  - Fix issue in admin-selected email attachments in Forms Email action.

## 1.1.3 (November 26, 2020)

  - Fix assets loading in multilingual sites (WordPress).
  - Fix auto-update issue (WordPress).

## 1.1.2 (November 25, 2020)

  - Fix update checking support (WordPress).

### Forms

  - Review elements placeholders.
  - Review actions settings.
  - Review Form Area status evaluation.
  - Fix range element php warning on new instances.
  - Fix elements control name fallback.
  - Fix empty attachments being sent in Email Action.

### Access

  - Review rules settings.
  - Fix season rule evaluation.
  - Fix guest user validation (WordPress).
  - Fix Date & Time evaluation if only one value is set.

## 1.1.1 (October 29, 2020)

  - Fix Forms Save to CSV action typo causing a php warning.

## 1.1.0 (October 28, 2020)

### Forms

  - Add extensions and mimetype HTML validation to Upload field.
  - Add delimiter and enclosure params to Save to CSV action.
  - Remove required attribute from Range field, as it's natively not supported.
  - Remove deprecated Submit element.
  - Fix Upload file size validation.
  - Fix Upload file overrides when file name collides.

### Access

  - Add Browser, Device, Operative System, IP Address, Day, Month, Season and Time rules.
  - Change Date rule timezone, is now assumed from the server configuration.

### Icons

  - Add icons picker new UI with grouped collections, lazy loading and global search.
  - Fix icons rendering on cached articles (Joomla).

### Elements

  - Remove file setting from Markdown element in favor of File Source.

## 1.1.0-beta.4 (October 13, 2020)

### Forms

  - Add spinner to Submit button.
  - Fix validation errors display.
  - Fix Radio and Checkbox template rendering issues.

### Icons

  - Fix build issue affecting collections.

## 1.1.0-beta.3 (October 7, 2020)

### Forms

  - Add text editor for Checkbox and Radio options.
  - Fix Input element nodes type.

### Icons

  - Add support for icons set as html element `uk-icon` attribute.

## 1.1.0-beta.2 (October 6, 2020)

### Forms

  - Add Button element with support for Submit and Reset buttons.
  - Add warn if reCaptcha was set more than once in the same Form Area.
  - Deprecate Submit element.
  - Fix Form Fieldset list of allowed fields.
  - Fix Form Input fields missing icon settings.
  - Fix Form elements attribute rendering.
  - Fix Form reCaptcha validation.
  - Fix Form Redirect action.

### Icons

  - Fix collections ubication.
  - Fix icon loading in modules (Joomla).

## 1.0.2 (October 5, 2020)

### Access

  - Fix Language rule (Joomla).

### Icons

  - Fix icon loading in footer and modules.

## 1.1.0-beta (October 1, 2020)

  - Add Forms Addon 🥳

### Access

  - Add URL rule.
  - Add Guest option for User Access rule (WordPress).

### Icons

  - Add Teenyicons collection.
  - Add method to add custom icon collections directories.
  - Review core collections.
  - Change icons Providers as icons Collections.

### Elements - Social Sharing

  - Add Title option.
  - Update custom size.
  - Review networks listing.
  - Fix custom icon rendering.

### Elements - Charts

  - Add Dynamic Content mapping and display options.
  - Fix Pie and Doughnut rendering.

## 1.0.1 (September 26, 2020)

  - Fix Icons rendering when the field is set on a parent element.

## 1.0.0 (July 22, 2020)

  - Add LinkedIn as Social Sharing preset network.

## 1.0.0-beta.7 (July 6, 2020)

  - Fix Joomla! install dependency check.

## 1.0.0-beta.6 (July 6, 2020)

  - Add Markdown element.
  - Add pre install/activate dependencies minimum version check.
  - Fix regression introduced in `beta.5` about plugin loading (WordPress).

### Icons

  - Fix picker modal performance when listing large amount of items.

## 1.0.0-beta.5 (July 2, 2020)

  - Add 1-click update support.
  - Add filter by name query for the icons selection Modal.
  - Add My Icons tab in icon picker, a collection of icons stored in the current Child Theme.

## 1.0.0-beta.4 (June 26, 2020)

### Access

  - Fix current locale for Language rule (WordPress).
  - Fix PHP warning when setting fields on some elements edge configurations.

### Icons

  - Fix collections support for attributes hard coded in value.

### Elements - Social Sharing

  - Add Advanced fields.
  - Fix links target.
  - Fix WhatsApp link.
  - Fix icon consistency for predefined networks.

## 1.0.0-beta.3 (June 23, 2020)

### Access

  - Fix Date rule help description and format parsing.

### Icons

  - Fix listing regression introduced in `beta.2`.

### Elements

  - Add `attributes` field in Advanced settings.
  - Fix Chart element data decimals input.

## 1.0.0-beta.2 (June 22, 2020)

### Access

  - Add user related rules a Strict option. When enabled the user must have all selected levels for the rule to validate.
  - Change Date Access Rule input value to ISO 8601 format: `YYYY-MM-DDThh:mm:ssTZD`.
  - Fix Language rule (WordPress).
  - Fix User Access rule (WordPress).

### Icons

  - Add support for extended Icons in buttons.
  - Add support for custom providers.
  - Change the nomenclature for 3rd party icon providers from `provider-group:icon-name` to `provider-group--icon-name`.
  - Fix icons rendering (WordPress).

### Elements

  - Fix mixed charts in Chart Element.
  - Change Chart element, Chart Type is now a global option with option to override on each Dataset.

## 1.0.0-beta (June 17, 2020)

  - First Release
