<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined('WPINC') or die;

abstract class YooessentialsInstaller
{
    const minPHP = '7.2';
    const minYTP = '2.3.32';
    const minWP = '3.1';

    public static function activate()
    {
        // check minimum PHP version
        if (!version_compare(PHP_VERSION, self::minPHP, 'ge')) {
            $msg = sprintf('PHP %s or later is required to run this plugin.', self::minPHP);
        }

        // check minimum WP version
        global $wp_version;
        if (!version_compare($wp_version, self::minWP, 'ge')) {
            $msg = sprintf('WordPress %s or later is required to run this plugin.', self::minWP);
        }

        // check minimum yootheme pro version
        if (
            $cfg = ABSPATH . '/wp-content/themes/yootheme/config.php' and
            !file_exists($cfg) or
            $cfg = (include($cfg)) and
            $version = (string) $cfg['theme']()['version'] and
            !version_compare($version, self::minYTP, 'ge')
        ) {
            $msg = sprintf('YOOtheme Pro %s or later is required to run this plugin.', self::minYTP);
        }

        // validate checksums
        $logs = self::validateChecksum();
        if (count($logs) > 0) {
            $logFile = fopen(ABSPATH . '/wp-content/zoolanders-missing.json', 'w');
            fwrite($logFile, json_encode($logs, JSON_PRETTY_PRINT));
            fclose($logFile);

            $msg = 'Not all the files where correctly installed. Please try again by installing the latest version that you can download from zoolanders.com or contact the support attaching <a href="/wp-content/zoolanders-missing.json">the list of missing or modified files</a>';
        }

        if (isset($msg)) {
            deactivate_plugins('yooessentials.php');
            exit($msg);
        }
    }

    protected static function validateChecksum(): array
    {
        $path = ABSPATH . '/wp-content/plugins/yooessentials/';
        $checksumFile = $path . 'checksums.txt';

        // if for some reason the file is not here, assume it's all ok
        if (!file_exists($checksumFile)) {
            return [];
        }

        $file = fopen($checksumFile, 'r');
        if (!$file) {
            return [];
        }

        $log = [];
        while ($row = fgets($file)) {
            list($md5, $fileName) = explode(' ', trim($row), 2);

            $filePath = $path . trim($fileName);
            $fileMd5 = md5_file($filePath);

            if (!file_exists($filePath)) {
                $log['missing'][] = $filePath;

                continue;
            }

            if ($fileMd5 !== $md5) {
                $log['wrong'][] = $filePath;
            }
        }

        return $log;
    }
}
