<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access;

use YOOtheme\Builder;
use ZOOlanders\YOOessentials\Addon;

return [

    'events' => [

        'customizer.init' => [
            AccessListener::class => ['initCustomizer', -10]
        ],

        'builder.type' => [
            AccessListener::class => ['builderType', -10]
        ]

    ],

    'extend' => [

        Builder::class => function (Builder $builder, $app) {
            if (!Addon::enabled(Access::class)) {
                return;
            }

            $builder->addTransform('render', $app(AccessTransform::class));
        }

    ],

    'services' => [

        Access::class => ''

    ],

    'loaders' => [
        'yooessentials-access-rules' => new AccessRuleLoader(),
    ],

    'yooessentials-access-rules' => [
        Rule\DateRule::class,
        Rule\TimeRule::class,
        Rule\DatetimeRule::class,
        Rule\DayRule::class,
        Rule\MonthRule::class,
        Rule\SeasonRule::class,
        Rule\UrlRule::class,
        Rule\IpRule::class,
        Rule\DeviceRule::class,
        Rule\BrowserRule::class,
        Rule\OsRule::class,
    ]

];
