<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use function YOOtheme\app;
use YOOtheme\Arr;
use YOOtheme\Str;
use ZOOlanders\YOOessentials\Access\Access;

/** @var Metadata $metadata */
$access = app(Access::class);

$groups = [
    'user' => [
        'label' => 'User',
        'type' => 'fields',
        'fields' => []
    ],
    'datetime' => [
        'label' => 'Date & Time',
        'type' => 'fields',
        'fields' => []
    ],
    'site' => [
        'label' => 'Site',
        'type' => 'fields',
        'fields' => []
    ],
    'device' => [
        'label' => 'Device',
        'type' => 'fields',
        'fields' => []
    ]
];

return [
    'title' => 'Access',
    'width' => 500,
    'fields' => array_reduce($access->getRules(), function ($carry, $rule) {
        $namespace = $rule->namespace();
        $group = $rule->group() ?? 'custom';

        $carry[$group] = $carry[$group] ?? [
            'label' => Str::upperFirst($group),
            'type' => 'fields',
            'fields' => []
        ];

        $carry[$group]['fields'] = Arr::merge($carry[$group]['fields'], [
            [
                'name' => $namespace,
                'type' => 'fields',
                'divider' => true,
                'fields' => [
                    "{$rule->namespace()}.state" => [
                        'text' => $rule->name(),
                        'type' => 'checkbox',
                        'description' => $rule->description()
                    ],
                    "{$rule->namespace()}._fields" => [
                        'type' => 'fields',
                        'show' => "{$rule->namespace()}.state",
                        'fields' => $rule->fields()
                    ]
                ]
            ]
        ]);

        return $carry;
    }, $groups)

];
