<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access;

use YOOtheme\Container;
use ZOOlanders\YOOessentials\Addon;

class AccessRuleLoader
{
    public function __invoke(Container $container, array $configs)
    {
        $container->extend(Access::class, static function (Access $access, $app) use ($configs) {
            if (!Addon::enabled(Access::class)) {
                return;
            }

            foreach ($configs as $classes) {
                foreach ($classes as $class) {
                    $access->addRule($class);
                }
            }
        });
    }
}
