<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access\Rule;

class DateRule extends TimeRule
{
    /**
     * @var String
     */
    protected $format = 'Y-m-d';

    public function name() : string
    {
        return 'Date';
    }

    public function namespace() : string
    {
        return 'yooessentials_access_date';
    }

    public function description() : string
    {
        return 'Validates if the current date is in the specified range.';
    }

    public function fields() : array
    {
        return [
            '_grid' => [
                'description' => 'Timezone from Site configuration is automatically applied.',
                'type' => 'grid',
                'width' => '1-2',
                'fields' => [
                    "{$this->namespace()}.publish_up" => [
                        'label' => 'From',
                        'attrs' => [
                            'type' => 'date',
                            'placeholder' => 'Y-m-d'
                        ]
                    ],
                    "{$this->namespace()}.publish_down" => [
                        'label' => 'To',
                        'attrs' => [
                            'type' => 'date',
                            'placeholder' => 'Y-m-d'
                        ]
                    ]
                ]
            ]
        ];
    }
}
