<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access\Rule;

use DateTime;

class DayRule extends TimeRule
{
    public function name() : string
    {
        return 'Day';
    }

    public function namespace() : string
    {
        return 'yooessentials_access_day';
    }

    public function description() : string
    {
        return 'Validates if the current day matches the selection.';
    }

    public function resolve($props, $node) : bool
    {
        if (!isset($props->days)) {
            return true;
        }

        $now = new DateTime('now', $this->tz);
        $currentDay = $now->format('N');

        return in_array($currentDay, (array) $props->days);
    }

    public function fields() : array
    {
        return [
            "{$this->namespace()}.days" => [
                'type' => 'select',
                'description' => 'The days that the current date must match. Timezone from Site configuration is automatically applied. Use the shift or ctrl/cmd key to select multiple entries.',
                'attrs' => [
                    'multiple' => true,
                    'class' => 'uk-height-small'
                ],
                'options' => [
                    'Monday' => '1',
                    'Tuesday' => '2',
                    'Wednesday' => '3',
                    'Thursday' => '4',
                    'Friday' => '5',
                    'Saturday' => '6',
                    'Sunday' => '7'
                ]
            ]
        ];
    }
}
