<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access\Rule;

use YOOtheme\Arr;
use ZOOlanders\YOOessentials\Access\AccessRule;
use ZOOlanders\YOOessentials\Util\Ip as IpUtil;

class IpRule implements AccessRule
{
    public function group() : string
    {
        return 'device';
    }

    public function name() : string
    {
        return 'IP Address';
    }

    public function namespace() : string
    {
        return 'yooessentials_access_ip';
    }

    public function description() : string
    {
        return 'Validates if the IP address matches the selection.';
    }

    public function resolve($props, $node) : bool
    {
        if (!isset($props->ips)) {
            return true;
        }

        $selection = explode(',', str_replace([' ', "\r", "\n"], ['', '', ','], $props->ips));

        return Arr::some($selection, function ($range) {
            return IpUtil::checkIP($range);
        });
    }

    public function fields() : array
    {
        return [
            "{$this->namespace()}.ips" => [
                'type' => 'textarea',
                'attrs' => [
                    'rows' => 4,
                    'placeholder' => "127.0.0.1\n128.0-128.1\n129"
                ],
                'description' => 'A list of IP addresses and ranges that the device must match. Separate the entries with a comma and/or new line.'
            ]
        ];
    }
}
