<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

use function YOOtheme\app;
use YOOtheme\Builder;
use YOOtheme\Config;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Cache\Adapter\FilesystemAdapter;
use ZOOlanders\YOOessentials\Vendor\Symfony\Contracts\Cache\CacheInterface;

return [

    'config' => [
        'yooessentials' => [
            'version' => '1.2.7',
            'build' => ''
        ]
    ],

    'events' => [

        'customizer.init' => [
            CoreListener::class => ['initCustomizer', -10],
        ],

        'metadata.load' => [
            CoreListener::class => ['loadMetadata', -10],
        ],

        'yooessentials.error' => [
            ErrorListener::class => 'debug',
        ],

    ],

    'extend' => [

        Builder::class => function (Builder $builder) {
            $update = app(UpdateTransform::class);
            $builder->addTransform('preload', $update);

            if (Addon::enabled('element')) {
                $builder->addTypePath(Path::get('./elements/*/element.json'));
            }
        },

    ],

    'services' => [

        UpdateTransform::class => function (Config $config) {
            return new UpdateTransform($config('yooessentials.version'));
        },

        CacheInterface::class => function () {
            return new FilesystemAdapter('yooessentials', 0, Path::resolve('~theme/cache/'));
        }

    ],
];
