<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$el = $this->el('div');

$grid = $this->el('div', [

    'class' => [
        'uk-child-width-auto',
        'uk-grid-{gap}',
        'uk-flex-{text_align}[@{text_align_breakpoint} [uk-flex-{text_align_fallback}]]',
    ],

    'uk-grid' => true,
]);

?>

<?= $el($props, $attrs) ?>
    <?= $grid($props) ?>

    <?php foreach ($children as $child) : ?>
    <div><?= $builder->render($child, ['element' => $props]) ?></div>
    <?php endforeach ?>

    <?= $grid->end() ?>

    <script>
    UIkit.util.on('a[data-yooessentials-social-popup]', 'click', function (e) {
        e.preventDefault();

        var props = JSON.parse(this.dataset.yooessentialsSocialPopup);

        UIkit.util.assign(props, {
            left: (window.screen.width - props.width) / 2,
            top: (window.screen.height - props.height) / 4,
            resizible: 'yes',
            scrollbars: 'yes',
            menubar: 'no',
            location: 'no',
            directories: 'no',
            status: 'yes'
        });

        window.open(
            this.href, 'popupWindow', JSON.stringify(props).replace(/"|{|}/g, '').replace(/:/g, '=')
        );
    });
    </script>

<?= $el->end() ?>
