<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

use function YOOtheme\app;
use ZOOlanders\YOOessentials\Access\Access;
use ZOOlanders\YOOessentials\Form\Form;
use ZOOlanders\YOOessentials\Icons\Icons;
use ZOOlanders\YOOessentials\Source\SourceService;

class Addon
{
    /**
     * @var array
     */
    const ADDONS = [
        'source' => SourceService::class,
        'form' => Form::class,
        'access' => Access::class,
        'icons' => Icons::class,
        'element' => ''
    ];

    public static function exist($addon): bool
    {
        $ids = array_filter(array_merge(array_keys(self::ADDONS), array_values(self::ADDONS)));

        return in_array($addon, $ids);
    }

    public static function enabled($addon): bool
    {
        if (!self::exist($addon)) {
            throw new \Exception("Not Valid Addon: $addon");
        }

        return app()->config->get("~theme.yooessentials.$addon.state", true);
    }
}
