<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\app;
use YOOtheme\Builder;
use YOOtheme\Path;
use YOOtheme\View;
use ZOOlanders\YOOessentials\Addon;
use ZOOlanders\YOOessentials\Form\Controller\DownloadCsvController;
use ZOOlanders\YOOessentials\Form\Controller\FormController;
use ZOOlanders\YOOessentials\Form\Controller\SendTestEmailController;
use ZOOlanders\YOOessentials\Form\Html\HtmlHelper;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionRequest;

return [

    'routes' => [
        ['post', Action\EmailAction::TEST_EMAIL_URL, SendTestEmailController::class . '@send'],
        ['get', Action\SaveCsvAction::DOWNLOAD_CSV_URL, DownloadCsvController::class . '@download', ['allowed' => true]],
        ['get', '/yooessentials/actions', FormController::class . '@actions', ['allowed' => true]],
        ['post', FormSubmissionRequest::SUBMIT_URL, FormController::class . '@submit', ['allowed' => true]]
    ],

    'events' => [

        FormSubmissionRequest::SUBMISSION_EVENT => [
            FormListener::class => ['handleFormActions', -10]
        ],

        'customizer.init' => [
            FormListener::class => ['initCustomizer', -10]
        ],

        'builder.type' => [
            FormListener::class => ['addFormPanel', -10]
        ]

    ],

    'extend' => [

        Builder::class => function (Builder $builder, $app) {
            if (!Addon::enabled(Form::class)) {
                return;
            }

            $app->config->addFile('yooessentials.form.fields', Path::get('./config/form-fields.json'));

            $builder->addTypePath(Path::get('./elements/*/element.json'));

            $builder->addTransform('render', new ControlTransform);
            $builder->addTransform('preload', function ($node, $params) use ($app) {
                $isFormArea = $node->props['yooessentials_form']->state ?? false;

                if ($isFormArea) {
                    $node->formid = hash('crc32b', json_encode([
                        $app->config->get('req.url'), $params['parent']->id ?? 0, $params['index'] ?? 0
                    ]));
                }
            });
        },

        View::class => function (View $view) {
            $formHtmlHelper = app(HtmlHelper::class);
            $view['form'] = $formHtmlHelper;
        },

    ],

    'yooessentials-form-actions' => [
        Action\EmailAction::class,
        Action\MessageAction::class,
        Action\RedirectAction::class,
        Action\SaveCsvAction::class,
    ],

    'services' => [
        FormSubmissionRequest::class => '',
        FormService::class => '',
    ],

    'loaders' => [
        'yooessentials-form-actions' => new ActionLoader(),
    ],

];
