<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$props = array_merge($node->propsControl, array_filter($child->control->props));

$showLabel = $node->props['show_label'] ?? false;
$showIcon = $node->props['show_icon'] ?? false;

if ($element['fullwidth'] ?? false) {
    $props['width'] = '';
}

$control = $this['form']->control(
    $child->control->name,
    $showLabel ? ($props['label'] ?? null) : null,
    $props['required'] ?? null
);

$icon = $this['form']->inputIcon();

$input = $this['form']->input([

    'id' => $child->control->name,
    'type' => str_replace('yooessentials_form_input_', '', $child->type),
    'name' => $child->control->name,
    'value' => $child->control->value,
    'required' => (bool) ($child->control->props['required'] ?? null),
    'readonly' => (bool) ($child->control->props['readonly'] ?? null),
    'autofocus' => (bool) ($child->control->props['autofocus'] ?? null),
    'pattern' => $child->control->props['pattern'] ?? null,
    'min' => $child->control->props['min'] ?? $child->control->props['mindate'] ?? null,
    'max' => $child->control->props['max'] ?? $child->control->props['maxdate'] ?? null,
    'minlength' => $child->control->props['minlength'] ?? null,
    'maxlength' => $child->control->props['maxlength'] ?? null,
    'placeholder' => $child->control->props['placeholder'] ?? null

])->render($child->control->props, [
    'state' => $child->control->errors ? 'danger' : null
]);

?>

<?= $control() ?>

    <?php if ($showIcon && $props['icon']) : ?>

        <div class="uk-inline uk-display-block">

            <?= $icon([
                'icon' => $props['icon'],
                'align' => $props['icon_align']
            ]) ?>

            <?= $input ?>

        </div>

    <?php else : ?>

        <?= $input ?>

    <?php endif ?>

<?= $control->end() ?>
