<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$el = $this->el('div');

$control = $this['form']->control(
    $node->control->name,
    $node->control->props['label'],
    $node->control->props['required']
);

$options = array_map(function ($child) use ($node) {
    $value = $child->props['value'];
    $text = strip_tags($child->props['text'], '<a>');
    $disabled = $child->props['disabled'];
    $checked = $value === $node->control->value;

    if ($value === '') {
        $value = true;
    }

    $label = $this->el('label', [
        'class' => [
            '[uk-disabled uk-text-muted {@disabled}]'
        ]
    ]);

    $input = $this->el('input', [
        'type' => 'radio',
        'name' => $node->control->name,
        'class' => [
            'uk-radio'
        ]
    ]);

    $label->attr(compact('disabled'));
    $input->attr(compact('disabled', 'checked', 'value'));

    return (object) [
        'label' => $label,
        'text' => $text,
        'input' => $input
    ];
}, $children);

?>

<?= $el($props, $attrs) ?>

    <?= $control() ?>

    <?php if ($node->control->props['layout'] === 'horizontal') : ?>
    <div class="uk-margin uk-grid-small uk-child-width-auto" uk-grid>
    <?php endif; ?>

    <?php foreach ($options as $option) : ?>

        <?= $option->label->attr(['class' => 'uk-flex uk-margin-right']) ?>
            <div><?= $option->input ?></div>
            <div class="uk-margin-small-left"><?= $option->text ?></div>
        <?= $option->label->end() ?>

    <?php endforeach ?>

    <?php if ($node->control->props['layout'] === 'horizontal') : ?>
    </div>
    <?php endif; ?>

    <?= $control->end() ?>

<?= $el->end() ?>
