<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use function YOOtheme\App;
use YOOtheme\Metadata;

/** @var Metadata $metadata */
$metadata = app(Metadata::class);

$id = 'reCAPTCHA' . str_replace(['#', '-'], '', $node->id);
$action = $node->control->props['action'];

$metadata->set('script:yooessentials-recaptcha', ['src' => "https://www.google.com/recaptcha/api.js?render={$node->siteKey}", 'async' => true, 'defer' => true]);

?>

<input type="hidden" id="<?= $id; ?>"/>

<script type="text/javascript">
    var recaptchaEl = UIkit.util.$('#<?= $id; ?>');
    var formEl = recaptchaEl.closest('form');

    UIkit.util.on(formEl, 'pre:submit', function(e) {
        e.preventDefault();

        var form = UIkit.yooessentialsForm(formEl);

        grecaptcha.ready(function() {
            grecaptcha.execute('<?= $node->siteKey ?>', {action: '<?= $action ?>'}).then(function(token) {
                form.doSubmit({
                    'g-recaptcha-response': token
                });
            });
        });
    });
</script>
