<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$el = $this->el('div');

$control = $this['form']->control(
    $node->control->name,
    $node->control->props['label'],
    $node->control->props['required']
);

$select = $this['form']->select([
    'id' => $node->control->name,
    'name' => $node->control->props['multiple'] ? $node->control->name . '[]' : $node->control->name,
    'required' => (bool) $node->control->props['required'] ?? null,
    'multiple' => (bool) $node->control->props['multiple'] ?? null,
    'autofocus' => (bool) $node->control->props['autofocus'] ?? null,
    'size' => $node->control->props['height'] ?? null
]);

?>

<?= $el($props, $attrs) ?>

    <?= $control() ?>

        <?= $select($node->control->props, [
            'state' => $node->control->errors ? 'danger' : null
        ]) ?>

            <?php foreach ($children as $child) : ?>

                <?php
                    $text = $child->props['text'];
                    $value = $child->props['value'];
                    $disabled = $child->props['disabled'];
                    $selected = in_array($value, $node->control->value);

                    if ($value === '') {
                        $value = true;
                    }

                    $option = $this->el('option', compact('disabled', 'selected', 'value'), $text);
                ?>

                <?= $option() ?>

            <?php endforeach ?>

        <?= $select->end() ?>

    <?= $control->end() ?>

<?= $el->end() ?>
