<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form\Action;

use function YOOtheme\app;
use YOOtheme\Path;
use YOOtheme\Url;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionResponse;

class RedirectAction extends StandardAction implements Action
{
    protected $configKey = 'action-redirect';

    public function name() : string
    {
        return 'Redirect';
    }

    public function panel(): array
    {
        return app()->config->loadFile(Path::get('../../config/action/redirect.json'));
    }

    public function __invoke(FormSubmissionResponse $response, callable $next): FormSubmissionResponse
    {
        if ($response->submission()->form()->hasExternalActionUrl()) {
            return $next($response);
        }

        $config = $this->getConfig();

        $redirect = Url::to($config['redirect'] ?? '');
        $message = $config['message'] ?? false;

        return $next($response->withData([
            'message' => $message,
            'redirect' => $redirect
        ]));
    }
}
