<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\app;
use ZOOlanders\YOOessentials\Access\Access;

class Form
{
    /**
     * @var string
     */
    protected $id;

    /**
     * @var array
     */
    protected $config = [];

    public function __construct(string $id, array $config = [])
    {
        $this->id = $id;
        $this->config = $config;
    }

    public function id(): string
    {
        return $this->id;
    }

    public function config(): array
    {
        return $this->config;
    }

    public function controls(): array
    {
        return $this->config()['controls'] ?? [];
    }

    public function control(string $name): array
    {
        foreach ($this->controls() as $control) {
            $controlName = $control['name'] ?? false;
            if ($controlName !== $name) {
                continue;
            }

            return $control;
        }

        return [];
    }

    public function hasActions(): bool
    {
        return count($this->actions()) > 0;
    }

    public function hasExternalActionUrl(): bool
    {
        $config = $this->config();

        return ($config['override_action_url'] ?? false && $config['action_url'] ?? '');
    }

    public function hasAction(string $action): bool
    {
        $action = $this->actions()[$action] ?? null;

        /** @var Access $access */
        $access = app(Access::class);

        // conditional execution
        return $action && $access->resolveNode((object) ['props' => $action]);
    }

    public function actionConfigs(string $action): array
    {
        return $this->actions()[$action] ?? [];
    }

    public function actions(): array
    {
        $actions = $this->config()['after_submit_actions'] ?? [];

        return array_reduce($actions, function ($carry, $config) {
            $carry[$config['type']][] = $config['props'];

            return $carry;
        }, []);
    }
}
