<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Icons\Wordpress;

use ZOOlanders\YOOessentials\Addon;
use ZOOlanders\YOOessentials\Icons\Icons;

class IconsListener
{
    // using a script workaround as in WordPress the head is inited too early
    public static function loadIcons(Icons $iconLoader)
    {
        if (!Addon::enabled(Icons::class)) {
            return;
        }

        if ($icons = $iconLoader->getQueued() and !empty($icons)) {
            echo sprintf('<script>UIkit.icon.add(%s)</script>', json_encode($icons));
        }
    }
}
