<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Icons;

use function YOOtheme\app;

class IconTransform
{
    /**
     * Transform callback.
     *
     * @param object $node
     * @param array  $params
     */
    public function __invoke($node, array $params)
    {
        /**
         * @var Icons $icons
         */
        $icons = app(Icons::class);

        foreach ($icons->retrieveIcons($node, $params['type']) as $icon) {
            $icons->load($icon, $params);
        }
    }
}
