<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Icons;

use YOOtheme\Config;
use YOOtheme\Metadata;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Addon;

class IconsListener
{
    public static function initCustomizer(Config $config, Icons $icons, Metadata $metadata)
    {
        $config->addFile('customizer', Path::get('../config/customizer.json'));

        if (!Addon::enabled(Icons::class)) {
            return;
        }

        $metadata->set('script:yooessentials-customizer-icons', ['src' => '~yooessentials_url/modules/icons/assets/customizer.min.js', 'defer' => true]);
    }
}
