<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use function YOOtheme\app;

/** @var SourceService $service */
$service = app(SourceService::class);

$providers = [];
foreach ($service->providers() as $class => $source) {
    $providers[] = (array) $source->config();
}

return [
    'yooessentials' => [
        'source' => [
            'providers' => $providers
        ]
    ],
    'sections' => [
        'yooessentials-sources' => [
            'title' => 'Sources',
            'priority' => 25,
            'width' => 350
        ]
    ]
];
