<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Csv\Type;

use YOOtheme\Str;
use ZOOlanders\YOOessentials\Source\SourceService;
use ZOOlanders\YOOessentials\Vendor\League\Csv\Reader;

class CsvFileType
{
    public static function config(Reader $reader, string $label): array
    {
        $fields = [];

        foreach ($reader->getHeader() as $header) {
            $fields[SourceService::encodeField($header)] = [
                'type' => 'String',
                'metadata' => [
                    'label' => Str::titleCase($header),
                    'fields' => []
                ]
            ];
        }

        return [
            'fields' => $fields,
            'metadata' => [
                'type' => true,
                'label' => $label,
            ],
        ];
    }
}
