<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\GoogleSheet;

use function YOOtheme\app;
use ZOOlanders\YOOessentials\Source\ConnectedAccount;
use ZOOlanders\YOOessentials\Source\ConnectedAccountsService;
use ZOOlanders\YOOessentials\Vendor\Google_Client;
use ZOOlanders\YOOessentials\Vendor\GuzzleHttp;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Cache\Adapter\FilesystemAdapter;
use ZOOlanders\YOOessentials\Vendor\Symfony\Contracts\Cache\CacheInterface;

trait HasGoogleClient
{
    protected static function createGoogleClient(ConnectedAccount $account): Google_Client
    {
        /** @var FilesystemAdapter $cache */
        $cache = app(CacheInterface::class);

        $client = new Google_Client();
        $client->setHttpClient(new GuzzleHttp\Client());
        $client->setClientId('1084661277420-9jleq1k3bmam11ibd7sq6figa0phabi1.apps.googleusercontent.com');
        $client->setClientSecret('Tl6XAv0vw9NHq3CXT_uda5Kp');
        $client->setAccessToken([
            'expires_in' => $account->expiresIn(),
            'access_token' => $account->accessToken,
            'refresh_token' => $account->refreshToken,
        ]);

        $client->setCache($cache);
        $client->setCacheConfig([
            'prefix' => 'google-sheets-client'
        ]);

        if ($account->isTokenExpiring()) {
            $client->fetchAccessTokenWithRefreshToken($account->refreshToken);
            $account->accessToken = $client->getAccessToken()['access_token'] ?? $account->accessToken;

            /** @var ConnectedAccountsService $service */
            $service = app(ConnectedAccountsService::class);
            $service->saveAccounts([$account]);
        }

        return $client;
    }
}
