<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\GoogleSheet\Type;

use YOOtheme\Str;
use ZOOlanders\YOOessentials\Source\SourceService;
use ZOOlanders\YOOessentials\Vendor\Google\Service\Exception;
use ZOOlanders\YOOessentials\Vendor\Google_Client;
use ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets;

class SheetType
{
    public static function config(string $id, Google_Client $client): array
    {
        $spreadSheet = null;

        try {
            $service = new Google_Service_Sheets($client);
            $spreadSheet = $service->spreadsheets->get($id);
        } catch (Exception $e) {
            if ($e->getCode() === 401) {
                $service = new Google_Service_Sheets($client);
                $spreadSheet = $service->spreadsheets->get($id);
            }
        }

        if (!$spreadSheet) {
            return [];
        }

        try {
            $title = $spreadSheet->getProperties()->getTitle();
            $values = $service->spreadsheets_values->get($spreadSheet->spreadsheetId, 'A1:Z1')->getValues();
            $headers = $values ? array_shift($values) : [];

            $fields = [];
            foreach ($headers as $header) {
                $fields[SourceService::encodeField($header)] = [
                    'type' => 'String',
                    'metadata' => [
                        'label' => Str::titleCase($header),
                        'fields' => [
                        ]
                    ]
                ];
            }

            return [
                'fields' => $fields,
                'metadata' => [
                    'type' => true,
                    'label' => $title,
                ],
            ];
        } catch (\Exception $e) {
            return [];
        }
    }
}
