<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Instagram;

use YOOtheme\Http\Request;
use YOOtheme\Http\Response;
use ZOOlanders\YOOessentials\Source\ConnectedAccount;

class InstagramController
{
    /**
     * @var string
     */
    public const PAGES_URL = '/yooessentials/source/instagram/pages';

    /**
     * @var string
     */
    public const TEST_URL = 'yooessentials/source/instagram/test';

    public function pages(Request $request, Response $response, InstagramApi $instagramApi)
    {
        $account = $request->getParam('account');
        $token = new ConnectedAccount($account);
        $instagramApi->addToken($token);
        $pages = $instagramApi->pages([$token->id]);

        return $response
            ->withJson($pages[$token->id] ?? [])
            ->withStatus(200);
    }

    public function test(Request $request, Response $response)
    {
        $args = $request->getParsedBody();
        $userId = $args['user_id'] ?? null;

        if (!$userId) {
            return $response->withStatus(400, 'No Account has been specified.');
        }

        return $response->withStatus(200);
    }
}
