<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use YOOtheme\Builder\Source;
use YOOtheme\Config;
use YOOtheme\Http\Request;
use YOOtheme\Metadata;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Addon;

class SourceListener
{
    public static function initCustomizer(Config $config, Metadata $metadata, SourceService $service)
    {
        $config->addFile('customizer', Path::get('../config/settings.json'));

        if (!Addon::enabled(SourceService::class)) {
            return;
        }

        $config->addFile('customizer', Path::get('../config/customizer.php'));
        $metadata->set('script:yooessentials-source', ['src' => '~yooessentials_url/modules/source/assets/customizer.min.js', 'defer' => true]);
    }

    /**
     * @param SourceService $service
     * @param Source $source
     */
    public static function initSource(SourceService $service, Request $request, $source)
    {
        if (!Addon::enabled(SourceService::class)) {
            return;
        }

        // Do we have not yet saved sources? If so, use them not the stored ones
        if (json_decode($request->getParam('yooessentialsSources'), true) ?? []) {
            return;
        }

        foreach ($service->providers() as $provider) {
            if ($provider && $provider instanceof SourceProviderInterface) {
                $sourceConfig = $service->sources($provider->config()->name);
                $provider->initSource($source, $sourceConfig);
            }
        }
    }
}
