<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use YOOtheme\Container;
use ZOOlanders\YOOessentials\Addon;

class SourcesLoader
{
    public function __invoke(Container $container, array $configs)
    {
        $container->extend(SourceService::class, static function (SourceService $service, $app) use ($configs) {
            if (!Addon::enabled(SourceService::class)) {
                return;
            }

            foreach ($configs as $classes) {
                foreach ($classes as $class) {
                    $service->addSourceProvider($class);
                }
            }
        });
    }
}
