<?php

namespace ZOOlanders\YOOessentials\Vendor\Google\AuthHandler;

use ZOOlanders\YOOessentials\Vendor\Google\Auth\CredentialsLoader;
use ZOOlanders\YOOessentials\Vendor\Google\Auth\HttpHandler\HttpHandlerFactory;
use ZOOlanders\YOOessentials\Vendor\Google\Auth\FetchAuthTokenCache;
use ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\AuthTokenMiddleware;
use ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\ScopedAccessTokenMiddleware;
use ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\SimpleMiddleware;
use ZOOlanders\YOOessentials\Vendor\GuzzleHttp\Client;
use ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface;
use ZOOlanders\YOOessentials\Vendor\Psr\Cache\CacheItemPoolInterface;
/**
* This supports Guzzle 6
*/
class Guzzle6AuthHandler
{
    protected $cache;
    protected $cacheConfig;
    public function __construct(\ZOOlanders\YOOessentials\Vendor\Psr\Cache\CacheItemPoolInterface $cache = null, array $cacheConfig = [])
    {
        $this->cache = $cache;
        $this->cacheConfig = $cacheConfig;
    }
    public function attachCredentials(\ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface $http, \ZOOlanders\YOOessentials\Vendor\Google\Auth\CredentialsLoader $credentials, callable $tokenCallback = null)
    {
        // use the provided cache
        if ($this->cache) {
            $credentials = new \ZOOlanders\YOOessentials\Vendor\Google\Auth\FetchAuthTokenCache($credentials, $this->cacheConfig, $this->cache);
        }
        return $this->attachCredentialsCache($http, $credentials, $tokenCallback);
    }
    public function attachCredentialsCache(\ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface $http, \ZOOlanders\YOOessentials\Vendor\Google\Auth\FetchAuthTokenCache $credentials, callable $tokenCallback = null)
    {
        // if we end up needing to make an HTTP request to retrieve credentials, we
        // can use our existing one, but we need to throw exceptions so the error
        // bubbles up.
        $authHttp = $this->createAuthHttp($http);
        $authHttpHandler = \ZOOlanders\YOOessentials\Vendor\Google\Auth\HttpHandler\HttpHandlerFactory::build($authHttp);
        $middleware = new \ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\AuthTokenMiddleware($credentials, $authHttpHandler, $tokenCallback);
        $config = $http->getConfig();
        $config['handler']->remove('google_auth');
        $config['handler']->push($middleware, 'google_auth');
        $config['auth'] = 'google_auth';
        $http = new \ZOOlanders\YOOessentials\Vendor\GuzzleHttp\Client($config);
        return $http;
    }
    public function attachToken(\ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface $http, array $token, array $scopes)
    {
        $tokenFunc = function ($scopes) use($token) {
            return $token['access_token'];
        };
        $middleware = new \ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\ScopedAccessTokenMiddleware($tokenFunc, $scopes, $this->cacheConfig, $this->cache);
        $config = $http->getConfig();
        $config['handler']->remove('google_auth');
        $config['handler']->push($middleware, 'google_auth');
        $config['auth'] = 'scoped';
        $http = new \ZOOlanders\YOOessentials\Vendor\GuzzleHttp\Client($config);
        return $http;
    }
    public function attachKey(\ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface $http, $key)
    {
        $middleware = new \ZOOlanders\YOOessentials\Vendor\Google\Auth\Middleware\SimpleMiddleware(['key' => $key]);
        $config = $http->getConfig();
        $config['handler']->remove('google_auth');
        $config['handler']->push($middleware, 'google_auth');
        $config['auth'] = 'simple';
        $http = new \ZOOlanders\YOOessentials\Vendor\GuzzleHttp\Client($config);
        return $http;
    }
    private function createAuthHttp(\ZOOlanders\YOOessentials\Vendor\GuzzleHttp\ClientInterface $http)
    {
        return new \ZOOlanders\YOOessentials\Vendor\GuzzleHttp\Client(['base_uri' => $http->getConfig('base_uri'), 'http_errors' => \true, 'verify' => $http->getConfig('verify'), 'proxy' => $http->getConfig('proxy')]);
    }
}
