<?php

/*
 * This file is part of the league/commonmark package.
 *
 * (c) Colin O'Dell <colinodell@gmail.com>
 *
 * Original code based on the CommonMark JS reference parser (https://bitly.com/commonmark-js)
 *  - (c) John MacFarlane
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace ZOOlanders\YOOessentials\Vendor\League\CommonMark;

/**
 * Converts CommonMark-compatible Markdown to HTML.
 */
class CommonMarkConverter extends \ZOOlanders\YOOessentials\Vendor\League\CommonMark\Converter
{
    /**
     * The currently-installed version.
     *
     * This might be a typical `x.y.z` version, or `x.y-dev`.
     *
     * @deprecated in 1.5.0 and will be removed from 2.0.0.
     *   Use \Composer\InstalledVersions provided by composer-runtime-api instead.
     */
    public const VERSION = '1.5.8';
    /** @var EnvironmentInterface */
    protected $environment;
    /**
     * Create a new commonmark converter instance.
     *
     * @param array<string, mixed>      $config
     * @param EnvironmentInterface|null $environment
     */
    public function __construct(array $config = [], \ZOOlanders\YOOessentials\Vendor\League\CommonMark\EnvironmentInterface $environment = null)
    {
        if ($environment === null) {
            $environment = \ZOOlanders\YOOessentials\Vendor\League\CommonMark\Environment::createCommonMarkEnvironment();
        }
        if ($environment instanceof \ZOOlanders\YOOessentials\Vendor\League\CommonMark\ConfigurableEnvironmentInterface) {
            $environment->mergeConfig($config);
        }
        $this->environment = $environment;
        parent::__construct(new \ZOOlanders\YOOessentials\Vendor\League\CommonMark\DocParser($environment), new \ZOOlanders\YOOessentials\Vendor\League\CommonMark\HtmlRenderer($environment));
    }
    public function getEnvironment() : \ZOOlanders\YOOessentials\Vendor\League\CommonMark\EnvironmentInterface
    {
        return $this->environment;
    }
}
