<?php

/*
 * This file is part of the league/commonmark package.
 *
 * (c) Colin O'Dell <colinodell@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace ZOOlanders\YOOessentials\Vendor\League\CommonMark\Extension\TaskList;

use ZOOlanders\YOOessentials\Vendor\League\CommonMark\Inline\Element\AbstractInline;
final class TaskListItemMarker extends \ZOOlanders\YOOessentials\Vendor\League\CommonMark\Inline\Element\AbstractInline
{
    /** @var bool */
    protected $checked = \false;
    public function __construct(bool $isCompleted)
    {
        $this->checked = $isCompleted;
    }
    public function isChecked() : bool
    {
        return $this->checked;
    }
    public function setChecked(bool $checked) : self
    {
        $this->checked = $checked;
        return $this;
    }
}
