<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

/**
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
final class KeyValueException extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException
{
    public const COMPONENT = 'component';
    /**
     * {@inheritDoc}
     */
    protected $defaultTemplates = [self::MODE_DEFAULT => [self::STANDARD => 'Key {{name}} must be present', self::COMPONENT => '{{baseKey}} must be valid to validate {{comparedKey}}'], self::MODE_NEGATIVE => [self::STANDARD => 'Key {{name}} must not be present', self::COMPONENT => '{{baseKey}} must not be valid to validate {{comparedKey}}']];
    protected function chooseTemplate() : string
    {
        return $this->getParam('component') ? self::COMPONENT : self::STANDARD;
    }
}
