<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

use ArrayIterator;
use Countable;
use RecursiveIterator;
use UnexpectedValueException;
/**
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
final class RecursiveExceptionIterator implements \RecursiveIterator, \Countable
{
    /**
     * @var ArrayIterator<int, ValidationException>
     */
    private $exceptions;
    public function __construct(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\NestedValidationException $parent)
    {
        $this->exceptions = new \ArrayIterator($parent->getChildren());
    }
    public function count() : int
    {
        return $this->exceptions->count();
    }
    public function hasChildren() : bool
    {
        if (!$this->valid()) {
            return \false;
        }
        return $this->current() instanceof \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\NestedValidationException;
    }
    public function getChildren() : self
    {
        $exception = $this->current();
        if (!$exception instanceof \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\NestedValidationException) {
            throw new \UnexpectedValueException();
        }
        return new static($exception);
    }
    /**
     * @return ValidationException|NestedValidationException
     */
    public function current() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException
    {
        return $this->exceptions->current();
    }
    public function key() : int
    {
        return (int) $this->exceptions->key();
    }
    public function next() : void
    {
        $this->exceptions->next();
    }
    public function rewind() : void
    {
        $this->exceptions->rewind();
    }
    public function valid() : bool
    {
        return $this->exceptions->valid();
    }
}
