<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation;

use finfo;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\Key;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Constraint;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Validator\ValidatorInterface as SymfonyValidator;
use ZOOlanders\YOOessentials\Vendor\Zend\Validator\ValidatorInterface as ZendValidator;
interface StaticValidator
{
    public static function allOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function alnum(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function alpha(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function alwaysInvalid() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function alwaysValid() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function anyOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function arrayType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function arrayVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function attribute(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $validator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function base(int $base, ?string $chars = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function base64() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $minimum
     * @param mixed $maximum
     */
    public static function between($minimum, $maximum) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function bic(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function boolType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function boolVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function bsn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function call(callable $callable, \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function callableType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function callback(callable $callback) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function charset(string ...$charset) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function cnh() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function cnpj() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function control(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function consonant(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $containsValue
     */
    public static function contains($containsValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[] $needles
     */
    public static function containsAny(array $needles, bool $strictCompareArray = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function countable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function countryCode(?string $set = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function currencyCode() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function cpf() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function creditCard(?string $brand = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function date(string $format = 'Y-m-d') : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function dateTime(?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function decimal(int $decimals) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function digit(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function directory() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function domain(bool $tldCheck = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function each(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function email() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $endValue
     */
    public static function endsWith($endValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function equals($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function equivalent($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function even() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function executable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function exists() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function extension(string $extension) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function factor(int $dividend) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function falseVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function fibonacci() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function file() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[]|int $options
     */
    public static function filterVar(int $filter, $options = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function finite() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function floatVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function floatType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function graph(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function greaterThan($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function hexRgbColor() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function iban() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function identical($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function image(?\finfo $fileInfo = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function imei() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[]|mixed $haystack
     */
    public static function in($haystack, bool $compareIdentical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function infinite() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function instance(string $instanceName) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function intVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function intType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function ip(string $range = '*', ?int $options = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function isbn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function iterableType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function json() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function key(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $referenceValidator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function keyNested(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $referenceValidator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function keySet(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\Key ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function keyValue(string $comparedKey, string $ruleName, string $baseKey) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function languageCode(?string $set = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function leapDate(string $format) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function leapYear() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function length(?int $min = null, ?int $max = null, bool $inclusive = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function lowercase() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function lessThan($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function luhn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function macAddress() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function max($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function maxAge(int $age, ?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function mimetype(string $mimetype) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public static function min($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function minAge(int $age, ?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function multiple(int $multipleOf) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function negative() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function nfeAccessKey() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function nif() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function nip() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function no(bool $useLocale = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function noneOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function not(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function notBlank() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function notEmoji() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function notEmpty() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function notOptional() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function noWhitespace() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function nullable(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function nullType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function number() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function numericVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function objectType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function odd() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function oneOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function optional(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function perfectSquare() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function pesel() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function phone() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function phpLabel() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function pis() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function polishIdCard() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function positive() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function postalCode(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function primeNumber() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function printable(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function punct(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function readable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function regex(string $regex) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function resourceType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function roman() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function scalarVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function sf(\ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Constraint $constraint, ?\ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Validator\ValidatorInterface $validator = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function size(?string $minSize = null, ?string $maxSize = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function slug() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function sorted(string $direction) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function space(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $startValue
     */
    public static function startsWith($startValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function stringType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function stringVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function subdivisionCode(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[] $superset
     */
    public static function subset(array $superset) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function symbolicLink() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function time(string $format = 'H:i:s') : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function tld() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function trueVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function type(string $type) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function unique() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function uploaded() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function uppercase() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function url() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function uuid(?int $version = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function version() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function videoUrl(?string $service = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function vowel(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function when(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $if, \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $then, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $else = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function writable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function xdigit(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public static function yes(bool $useLocale = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param string|ZendValidator $validator
     * @param mixed[] $params
     */
    public static function zend($validator, ?array $params = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
}
